/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#include "U4AAPI.h"
#include _iCOMMANDLAYER_
#include _iHANDLERLAYER_
#include "Log.h"

u4aapi* u4aapi::instance = 0;

u4aapi::u4aapi() {

    l = log::instance();
}

u4aapi::~u4aapi() {

    delete u4aapi::instance->cl;
    delete u4aapi::instance->hl;
}

u4aapi* u4aapi::getInstance(){

    if (u4aapi::instance == 0) {
        u4aapi::instance = new u4aapi();
    }
    return u4aapi::instance;
}

int u4aapi::openDevice (int serial, char *disp , int ein, int eout) {

    u4aapi *u4atemp = u4aapi::getInstance();
    int id = u4atemp->cl->open(serial, disp, ein, eout);
    return id;
}

bool u4aapi::configDevice (int id, char *dconf, int len) {

    u4aapi *u4atemp;

    u4atemp = u4aapi::getInstance();
    return (u4atemp->hl->configure(id,dconf,len));
}

bool u4aapi::sendData (int id, char *dsend, int len, int timeout) {

    u4aapi *u4atemp;

    u4atemp = u4aapi::getInstance();
    return (u4atemp->hl->send(id, dsend, len, timeout));
}

bool u4aapi::receiveData (int id, char *drec, int len, int timeout) {

    u4aapi *u4atemp;
    char *temp;
    bool ok;

    u4atemp = u4aapi::getInstance();
    temp = u4atemp->hl->receive(id, ok, len, timeout);
    if (ok) {
        for (int i = 0; i < len ; i++)
            drec[i] = temp[i];
        delete [] temp;
        return true;
    }
    else {
        return false;
    }
}

bool u4aapi::closeDevice (int id) {

    u4aapi *u4atemp;

    u4atemp = u4aapi::getInstance();
    return (u4atemp->cl->close(id));
}

int u4aapi::getBaseBoardSerial(int index) {

    u4aapi *u4atemp;
    int *temp, serial, cant;

    u4atemp = u4aapi::getInstance();
    temp = u4atemp->cl->getBoards(cant);
    if (index < cant) {
        serial = temp[index];
    }
    else {
        serial = 0;
    }
    delete [] temp;
    return serial;
}

int u4aapi::qtyBaseBoards() {

    u4aapi *u4atemp;
    int cant, *temp;

    u4atemp = u4aapi::getInstance();
    temp = u4atemp->cl->getBoards(cant);
    delete [] temp;
    return cant;
}

int u4aapi::getUserModuleName(int serial, int index, char *name) {

    u4aapi *u4atemp;
    char *temp;
    int cant;

    if (index < 0) {
        name[0] = '\0';
        return HNDERROR;
    }
    u4atemp = u4aapi::getInstance();
    temp = u4atemp->cl->getModules(serial, cant);
    if (cant == 0) {
        name[0] = '\0';
        return cant;
    }
    else {
        if (index >= cant) {
            name[0] = '\0';
            delete [] temp;
            return HNDERROR;
        }
        else {
            for (int i=0 ; i<MAX_LEN_NAME ; i++) {
                name[i] = temp[(MAX_LEN_NAME*index)+i];
            }
            return strlen(name);
        }
    }
}

int u4aapi::qtyUserModules(int serial) {

    u4aapi *u4atemp;
    int cant;
    char *temp;

    u4atemp = u4aapi::getInstance();
    temp = u4atemp->cl->getModules(serial, cant);
    if (cant > 0) {
        delete [] temp;
    }
    return cant;
}

void u4aapi::resetBaseBoard(int serial) {

    u4aapi *u4atemp;

    u4atemp = u4aapi::getInstance();
    u4atemp->cl->reset(serial);
}

void u4aapi::initAPI() {

    u4aapi *u4atemp;

    u4atemp = u4aapi::getInstance();
    _iHANDLERLAYER *temp = new _iHANDLERLAYER();
    u4atemp->hl = temp;
    u4atemp->cl = new _iCOMMANDLAYER(temp);
    temp = NULL;
}

int u4aapi::apiVersion () {

    u4aapi *u4atemp;

    u4atemp = u4aapi::getInstance();
    return(u4atemp->cl->getApiVersion());
}

int u4aapi::firmwareVersion (int serial) {

    u4aapi *u4atemp;

    u4atemp = u4aapi::getInstance();
    return(u4atemp->cl->getFirmwareVersion(serial));
}
